/* 
 * File:   DevShell.h
 * Author: david
 *
 * Created on November 26, 2012, 2:16 PM
 */

#ifndef DEVSHELL_H
#define	DEVSHELL_H

#include "overlapGraph.h"
#include "Pairing.h"
#include "readsLayout.h"
#include "readsStorage.h"
#include "BackwardsWalker.h"

#include<vector>
#include <iostream>
#include <string>
#include <sstream>
using namespace std;

class DevShell
{
public:
    DevShell();
    DevShell(const DevShell& orig);
    virtual ~DevShell();
    
    
    void init(OverlapsGraph *g, Pairing *p, ReadsStorage *r, ReadsLayout *l);
    void prompt();
    
private:
    
    vector<unsigned int> ePath;
    size_t p1; //two pointer on ePath that indicates the boundaries for either
    size_t p2; //desired amplicon or PE matches counts
    vector<unsigned int> pathNode;
    vector<bool> pathDir;
    string nodeList;
    
    unsigned int nodeID;
    bool nodeDir;
    vector<string> args;
    istringstream iss;
    bool checkDistances;
    int minNPair;
    double minRatio;
    
    BackwardsWalker BKW;
    unsigned int chosen;
    
    OverlapsGraph *G;
    Pairing *P;
    ReadsStorage *R;
    ReadsLayout *L;
    
    void parsePath(string rawPath);
    void parseNodeId(string buffer);

    inline void whatDoYouMean(ostream &out)
    {
        out << "??" << endl;
    }

    void printHelp(ostream &out);
    
    void growSearchTree();
    void elongateSearchTree();
    void Tree2seq();
    void drawGraph();
    void path2Seq();
    void reversePath();
    void printReadsLayout();
    void locateRead();
    void setCheckDistances();
    void p3(); //get input for primer3 website
    bool set_p1p2_ePath(); //from args(1)
    void dev();
    

    

};

#endif	/* DEVSHELL_H */

